/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWFileURLDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JOptionPane;

public class VWAttachmentSelectionHelper {
    public static VWAttachment browseForAttachment(IVWIDMItem IIDMItem, String dlgTitle, Container parent) {
        try {
            String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
            IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(IIDMItem, 95, resources[0], null);
            dialog.setTitle(dlgTitle);
            dialog.setButtonMnemonic(resources[1]);
            dialog.setButtonTooltip(VWResource.s_select);
            switch (dialog.showDialog(parent)) {
                case 0: {
                    IIDMItem = dialog.getSelectedItem();
                    if (IIDMItem == null) {
                        return null;
                    }
                    return IIDMItem.getVWAttachment();
                }
                case 2: {
                    VWFileURLDialog URLDlg = new VWFileURLDialog((Frame)parent);
                    int nURLReturnVal = URLDlg.showDialog(parent);
                    if (nURLReturnVal != 0) break;
                    String fileName = URLDlg.getSelectedFile();
                    if (fileName == null) {
                        return null;
                    }
                    VWAttachment newAttachment = new VWAttachment();
                    newAttachment.setType(5);
                    newAttachment.setId(fileName);
                    return newAttachment;
                }
            }
            return null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static void openURL(String url) throws VWException {
        try {
            URL tempURL = new URL(url);
            if (tempURL.getProtocol() == "http") {
                IVWIDMFactory vwIDMFactory = VWIDMBaseFactory.instance();
                IVWIDMFactoryProperties factoryProperties = vwIDMFactory.getProperties();
                Applet applet = (Applet)factoryProperties.getProperty("applet");
                if (applet == null) {
                    throw new VWException("VWAttachmentSelectionHelper.invoke", "Invalid environment.  No applet was configured!");
                }
                if (!applet.isActive()) {
                    return;
                }
                applet.getAppletContext().showDocument(new URL(url), "_blank");
            } else {
                String path = tempURL.getPath();
                if (path != null) {
                    int nIndex = path.indexOf(":");
                    if (nIndex != -1) {
                        String command = null;
                        command = OperatingSystem.isWindows() ? "cmd /c" : "netscape";
                        url = path.substring(nIndex - 1);
                        Runtime.getRuntime().exec(command + "\"" + url + "\"");
                    } else {
                        String command = null;
                        command = OperatingSystem.isWindows() ? "cmd /c start" : "netscape";
                        Runtime.getRuntime().exec(command + " " + url);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage());
        }
    }
}

